local super = require "View"

Oval = super:new()

local defaults = {
    thickness = 2,
}

local nilDefaults = {
}

local inspectorInfo = {
    {'Stroke', {'thickness'}, nil, 'Thickness'},
}

function Oval:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function Oval:unarchiveFill(archived)
    -- NOTE: Version 1.3.2 and earlier stored oval fill colors separately from the color scheme.
    self._legacyFill = unarchive(archived)
end

function Oval:unarchiveStroke(archived)
    -- NOTE: Version 1.3.2 and earlier stored oval stroke colors separately from the color scheme.
    self._legacyStroke = unarchive(archived)
end

function Oval:unarchived()
    if self._legacyFill then
        self:setPaint(ColorScheme.backgroundPaint, self._legacyFill)
    end
    if self._legacyStroke then
        self:setPaint(ColorScheme.strokePaint, self._legacyStroke)
    end
    super.unarchived(self)
end

function Oval:getInspectors()
    local list = super.getInspectors(self)
    list:add(self:createColorInspector(ColorScheme.backgroundPaint, nil, 'Fill'))
    list:add(self:createColorInspector(ColorScheme.strokePaint, nil, 'Stroke'))
    for i = 1, #inspectorInfo do
        local info = inspectorInfo[i]
        list:add(self:createInspector(unpack(info)))
    end
    return list
end

function Oval:padding()
    local thickness = self:getProperty('thickness')
    return {
        left = thickness/2,
        bottom = thickness/2,
        right = thickness/2,
        top = thickness/2,
    }
end

function Oval:draw(canvas)
    local fill = self:getPaint(ColorScheme.backgroundPaint)
    local stroke = self:getPaint(ColorScheme.strokePaint)
    local thickness = self:getProperty('thickness')
    local path = Path.oval(self:rect())
    canvas:setPaint(fill):fill(path)
    canvas:setThickness(thickness):setPaint(stroke):stroke(path)
end

return Oval
